/*
 * Decompiled with CFR 0.152.
 */
package net.dragonloot.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;

public class DragonArmor
extends ArmorItem {
    private static final UUID[] MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;
    private final int protection;
    private final float toughness;
    protected final float knockbackResistance;
    protected final EquipmentSlot slot;
    protected final ArmorMaterial material;

    public DragonArmor(ArmorMaterial material, ArmorItem.Type type, Item.Properties settings) {
        super(material, type, settings);
        this.material = material;
        this.slot = type.m_266308_();
        this.protection = material.m_7366_(type);
        this.toughness = material.m_6651_();
        this.knockbackResistance = material.m_6649_();
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)f_40376_);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID uUID = MODIFIERS[this.slot.m_20749_()];
        builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uUID, "Armor modifier", (double)this.protection, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(uUID, "Armor toughness", (double)this.toughness, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(uUID, "Armor knockback resistance", (double)this.knockbackResistance / 10.0, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return slot == this.slot ? this.attributeModifiers : super.m_7167_(slot);
    }
}

